/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.widgets;

import com.quantumdata.widgets.QDPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class QDNumberGrid
extends QDPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private int MAX_LINES = 16;
    private int CELLS_PER_LINE = 16;
    private boolean m_hasSecondRowHeading = false;
    private boolean m_hasHexHeadings = true;
    private JTextField[][] m_cells;
    private JLabel[] m_secCol;
    private JLabel m_secColHeading = null;
    private JLabel[] m_rowNums;
    private JLabel[] m_colNums;
    private Color m_bgndColor = new Color(0, 0, 128);
    private String m_defaultValue = "00";

    public QDNumberGrid(int n, int n2) {
        this(n, n2, false, true);
    }

    public QDNumberGrid(int n, int n2, boolean bl, boolean bl2) {
        String string;
        int n3;
        this.m_hasSecondRowHeading = bl;
        this.m_hasHexHeadings = bl2;
        this.MAX_LINES = n;
        this.CELLS_PER_LINE = n2;
        this.m_cells = new JTextField[this.MAX_LINES][];
        this.m_secCol = new JLabel[this.MAX_LINES];
        this.m_rowNums = new JLabel[this.MAX_LINES];
        this.m_colNums = new JLabel[this.CELLS_PER_LINE];
        int n4 = 1;
        if (this.m_hasSecondRowHeading) {
            n4 = 2;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 3, 0, 3);
        gridBagConstraints.insets = insets;
        Font font = new Font("Serif", 1, 12);
        JLabel jLabel = new JLabel("       ");
        jLabel.setBackground(Color.RED);
        jLabel.setOpaque(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        gridBagConstraints.insets = insets2;
        if (this.m_hasSecondRowHeading) {
            jLabel = new JLabel("");
            jLabel.setForeground(Color.MAGENTA);
            jLabel.setBackground(Color.DARK_GRAY);
            jLabel.setOpaque(true);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            this.m_secColHeading = jLabel;
        }
        gridBagConstraints.insets = insets;
        for (n3 = 0; n3 < this.CELLS_PER_LINE; ++n3) {
            if (this.m_hasHexHeadings) {
                string = Integer.toHexString(n3);
                if ((string = string.toUpperCase()).length() == 1) {
                    string = "0" + string;
                }
            } else {
                string = Integer.toString(n3);
            }
            jLabel = new JLabel(string);
            jLabel.setForeground(Color.WHITE);
            jLabel.setBackground(new Color(0, 0, 128));
            jLabel.setOpaque(true);
            jLabel.setHorizontalAlignment(0);
            gridBagConstraints.gridx = n3 + n4;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            this.m_colNums[n3] = jLabel;
        }
        for (n3 = 0; n3 < this.MAX_LINES; ++n3) {
            this.m_cells[n3] = new JTextField[this.CELLS_PER_LINE];
            gridBagConstraints.insets = insets;
            if (this.m_hasHexHeadings) {
                string = Integer.toHexString(n3);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                string = string.toUpperCase();
            } else {
                string = Integer.toString(n3);
            }
            jLabel = new JLabel(string);
            jLabel.setForeground(Color.WHITE);
            jLabel.setBackground(new Color(0, 0, 128));
            jLabel.setOpaque(true);
            jLabel.setHorizontalAlignment(0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n3 + 1;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            this.m_rowNums[n3] = jLabel;
            if (this.m_hasSecondRowHeading) {
                jLabel = new JLabel("00");
                jLabel.setForeground(Color.WHITE);
                jLabel.setBackground(Color.DARK_GRAY);
                jLabel.setOpaque(true);
                jLabel.setHorizontalAlignment(0);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = n3 + 1;
                gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                this.add(jLabel);
                this.m_secCol[n3] = jLabel;
            }
            ByteFocus byteFocus = new ByteFocus();
            for (int i = 0; i < this.CELLS_PER_LINE; ++i) {
                JTextField jTextField = new JTextField(4);
                jTextField.setForeground(Color.BLACK);
                jTextField.setBackground(Color.WHITE);
                jTextField.setOpaque(true);
                jTextField.setText(this.m_defaultValue);
                jTextField.setHorizontalAlignment(0);
                jTextField.setFont(font);
                gridBagConstraints.gridx = i + n4;
                gridBagConstraints.gridy = n3 + 1;
                String string2 = "" + i + "," + n3;
                jTextField.setName(string2);
                jTextField.addActionListener(this);
                jTextField.setActionCommand(string2);
                jTextField.addFocusListener(byteFocus);
                gridBagLayout.setConstraints(jTextField, gridBagConstraints);
                this.add(jTextField);
                this.m_cells[n3][i] = jTextField;
            }
        }
    }

    public void setSecColHeading(String string) {
        if (this.m_secColHeading != null) {
            this.m_secColHeading.setText(string);
        }
    }

    public void setDefaultValue(String string) {
        this.m_defaultValue = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JTextField) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            String[] stringArray = jTextField.getName().split(",");
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            this.setValue(jTextField, n, n2);
            return;
        }
    }

    protected void setValue(JTextField jTextField, int n, int n2) {
    }

    public void clearAll() {
        for (int i = 0; i < this.CELLS_PER_LINE; ++i) {
            for (int j = 0; j < this.MAX_LINES; ++j) {
                JTextField jTextField = this.m_cells[j][i];
                jTextField.setForeground(Color.black);
                jTextField.setText(this.m_defaultValue);
            }
        }
    }

    public int getRowCount() {
        return this.MAX_LINES;
    }

    public int getColCount() {
        return this.CELLS_PER_LINE;
    }

    public JTextField getCell(int n, int n2) {
        return this.m_cells[n2][n];
    }

    public void setCell(int n, int n2, String string) {
        this.m_cells[n2][n].setText(string);
    }

    public JLabel getSecColCell(int n) {
        return this.m_secCol[n];
    }

    private class ByteFocus
    implements FocusListener {
        private ByteFocus() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() instanceof JTextField) {
                JTextField jTextField = (JTextField)focusEvent.getSource();
                jTextField.setSelectionStart(0);
                jTextField.setSelectionEnd(jTextField.getText().length());
                String[] stringArray = jTextField.getName().split(",");
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                QDNumberGrid.this.m_rowNums[n2].setBackground(Color.yellow);
                QDNumberGrid.this.m_rowNums[n2].setForeground(Color.black);
                QDNumberGrid.this.m_colNums[n].setBackground(Color.yellow);
                QDNumberGrid.this.m_colNums[n].setForeground(Color.black);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() instanceof JTextField) {
                JTextField jTextField = (JTextField)focusEvent.getSource();
                String[] stringArray = jTextField.getName().split(",");
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                QDNumberGrid.this.m_rowNums[n2].setBackground(QDNumberGrid.this.m_bgndColor);
                QDNumberGrid.this.m_rowNums[n2].setForeground(Color.white);
                QDNumberGrid.this.m_colNums[n].setBackground(QDNumberGrid.this.m_bgndColor);
                QDNumberGrid.this.m_colNums[n].setForeground(Color.white);
            }
        }
    }
}

